/******************************************************************************
* Technical University of Darmstadt
* Industrial Process and System Communication
* Project: TCP
* Filename: TcpStarter.java
* Contents: Mainclass, initializes all subclasses.
******************************************************************************/

import control.Control;
import misc.Debug;
import sampling.BaseSampler;
import sampling.Watcher;
import java.awt.*;
import java.util.Vector;
import java.net.URL;

/******************************************************************************
* Class: TcpStarter
* Description: A TcpStarter object controls all subclasses. Therefore it
*              launches two control-threads.
******************************************************************************/
public class TcpStarter {

  TcpApplet parent = null;
  public final int maxapp=2;  // Anzahl der max.Applikationen auf dem Host
  public static URL home;
  int screenfactor = 1;       // to change screen resolutions
  int counter = 0;
  int steps = 0;
  int timeouttime = 10000;
  int timertime = 5000;
  int keepalivetimeout_time = 20000;
  public boolean singlestep = false;

  ImageGrabber grabimages;
  MainWindow mainwindow;      // Hauptfenster zur Darstellung
  Host host1, host2;
  FromAtoB ch_1,ch_2;

  HostNetBuffer  host1in  = new HostNetBuffer();
  HostNetBuffer  host1out = new HostNetBuffer();
  HostNetBuffer  host2in  = new HostNetBuffer();
  HostNetBuffer  host2out = new HostNetBuffer();
  CheckStatus chkstat = new CheckStatus();
  Application[] appsonh1 = new Application[maxapp]; // Applikationen auf Host1 erzeugen
  Application[] appsonh2 = new Application[maxapp]; // Applikationen auf Host2 erzeugen
  public static ThreadGroup halt;


// Start als Applikation
  public TcpStarter() {
    grabimages = new ImageGrabber( this, false );
    ch_1 = new FromAtoB(this, host1out,  host2in);
    ch_2 = new FromAtoB(this, host2out, host1in);
    host1 = new Host(this, "Host1",host1out,host1in,1);
    host2 = new Host(this, "Host2",host2out,host2in,2);
    mainwindow = new MainWindow( this );
    chkstat.CheckStatus(this);
    //Initialisierung der Applikationen
    for (counter=0;counter<=(maxapp-1);counter++) {
        appsonh1[counter]= new Application();
        appsonh2[counter]= new Application();
    }
    for (counter=0;counter<=(maxapp-1);counter++) {
        appsonh1[counter].Application( this, host1, "Application" +" "+ String.valueOf(counter) + " on host1");
        appsonh2[counter].Application( this, host2, "Application" +" "+ String.valueOf(counter) + " on host2");
    }
  }

// Start als Applet
  public TcpStarter( TcpApplet target ) {

    this.parent = target;
    grabimages = new ImageGrabber( this, true );
    ch_1 = new FromAtoB(this, host1out,  host2in);
    ch_2 = new FromAtoB(this, host2out, host1in);
    host1 = new Host(this, "Host1",host1out,host1in,1);
    host2 = new Host(this, "Host2",host2out,host2in,2);
    mainwindow = new MainWindow( this );
    chkstat. CheckStatus(this);
    //Initialisierung der Applikationen
    for (counter=0;counter<=(maxapp-1);counter++) {
        appsonh1[counter]= new Application();
        appsonh2[counter]= new Application();
    }
    for (counter=0;counter<=(maxapp-1);counter++) {
        appsonh1[counter].Application( this, host1, "Application" +" "+ String.valueOf(counter) + " on host1");
        appsonh2[counter].Application( this, host2, "Application" +" "+ String.valueOf(counter) + " on host2");
    }
  }


/******************************************************************************
* Method: main
* Description: creates TcpStarter object
* Parameters: none
* Return Value: none
******************************************************************************/
  public static void main(String args[]) {
  }
}

